//********************************************************************************
//
//                       C O P Y R I G H T  (c) 2011
//               S O F T W A R E   T O O L B O X   I N C.
//                           All Rights Reserved.
//   ........................................................................
//   This sample code is provided by Software Toolbox solely to assist in
//   understanding the use of the SLIK-DA OPC Data Access ActiveX Control. This
//   code is provided as-is and without warranty or support of any sort.
//
//********************************************************************************
//
//   Project:		SLIK-DA Interop Assembly
//
//   Description:   This sample server application is based on Software Toolbox's
//                  Simple Language Independent Toolkit for creating OPC Data
//                  Access servers (SLIK-DA).  It leverages the SLIK-DA Interop
//					Assembly that allows for the easy integration of this
//					ActiveX control into .NET applications.
//
//					This implementation replicates the VB Advanced OPC Server 
//					originally created to demonstrate various features of the 
//					SLIK-DA ActiveX Control in the VB6 environment.
//
//********************************************************************************
/// <summary>
/// The main entry point for the application.
/// </summary>

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Globalization;
using System.Runtime.InteropServices;
using NDI.SLIKDA.Interop;

namespace CSAdvancedServer
{
	//
	//	The frmMain class is a port of frmMain form in the VB Advanced Server 
	//	sample.  A SLIKServer object is contained on this form.  Event
	//	handlers for SLIKServer's OnRead() and OnWrite() events are 
	//	thus implemented by this class.
	//

	public class frmMain : System.Windows.Forms.Form
	{
		#region Windows Form Designer generated code
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ToolTip ToolTip1 = null;
		private System.Windows.Forms.Timer tmrMain = null;
		private System.Windows.Forms.MenuItem mnuFileClientDisc = null;
		private System.Windows.Forms.MenuItem mnuFileSep1 = null;
		private System.Windows.Forms.MenuItem mnuFileForceExit = null;
		private System.Windows.Forms.MenuItem mnuFileSep2 = null;
		private System.Windows.Forms.MenuItem mnuFileExit = null;
		private System.Windows.Forms.MenuItem mnuFile = null;
		private System.Windows.Forms.MenuItem mnuEditStatPeriod = null;
		private System.Windows.Forms.MenuItem mnuEdit = null;
		private System.Windows.Forms.MenuItem mnuTraceNone = null;
		private System.Windows.Forms.MenuItem mnuTraceConnect = null;
		private System.Windows.Forms.MenuItem mnuTraceGroup = null;
		private System.Windows.Forms.MenuItem mnuTraceItem = null;
		private System.Windows.Forms.MenuItem mnuTraceAll = null;
		private System.Windows.Forms.MenuItem mnuTraceSep1 = null;
		private System.Windows.Forms.MenuItem mnuTraceClear = null;
		private System.Windows.Forms.MenuItem mnuTraceSep2 = null;
		private System.Windows.Forms.MenuItem mnuTraceCOM = null;
		private System.Windows.Forms.MenuItem mnuTrace = null;
		private System.Windows.Forms.MenuItem mnuHelp = null;
		private System.Windows.Forms.MenuItem mnuHelpAbout = null;
		public System.Windows.Forms.TabControl tabMain;
		public System.Windows.Forms.TabPage _tabMain_TabPage0;
		public System.Windows.Forms.TabPage _tabMain_TabPage1;
		public System.Windows.Forms.TextBox txtTraceMsgs;
        public System.Windows.Forms.GroupBox fraDescription;
		public System.Windows.Forms.PictureBox imgCert;
		public System.Windows.Forms.Label lblDescription;
		private System.Windows.Forms.ListView lvStats;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
        private System.Windows.Forms.Timer tmrTagUpdate;
        private SLIKServer SLIKServer1;
		private System.Windows.Forms.MainMenu MainMenu1 = null;
		
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(frmMain));
            this.ToolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.tmrMain = new System.Windows.Forms.Timer(this.components);
            this.MainMenu1 = new System.Windows.Forms.MainMenu(this.components);
            this.mnuFile = new System.Windows.Forms.MenuItem();
            this.mnuFileClientDisc = new System.Windows.Forms.MenuItem();
            this.mnuFileSep1 = new System.Windows.Forms.MenuItem();
            this.mnuFileForceExit = new System.Windows.Forms.MenuItem();
            this.mnuFileSep2 = new System.Windows.Forms.MenuItem();
            this.mnuFileExit = new System.Windows.Forms.MenuItem();
            this.mnuEdit = new System.Windows.Forms.MenuItem();
            this.mnuEditStatPeriod = new System.Windows.Forms.MenuItem();
            this.mnuTrace = new System.Windows.Forms.MenuItem();
            this.mnuTraceNone = new System.Windows.Forms.MenuItem();
            this.mnuTraceConnect = new System.Windows.Forms.MenuItem();
            this.mnuTraceGroup = new System.Windows.Forms.MenuItem();
            this.mnuTraceItem = new System.Windows.Forms.MenuItem();
            this.mnuTraceAll = new System.Windows.Forms.MenuItem();
            this.mnuTraceSep1 = new System.Windows.Forms.MenuItem();
            this.mnuTraceClear = new System.Windows.Forms.MenuItem();
            this.mnuTraceSep2 = new System.Windows.Forms.MenuItem();
            this.mnuTraceCOM = new System.Windows.Forms.MenuItem();
            this.mnuHelp = new System.Windows.Forms.MenuItem();
            this.mnuHelpAbout = new System.Windows.Forms.MenuItem();
            this.tabMain = new System.Windows.Forms.TabControl();
            this._tabMain_TabPage0 = new System.Windows.Forms.TabPage();
            this.lvStats = new System.Windows.Forms.ListView();
            this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
            this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
            this._tabMain_TabPage1 = new System.Windows.Forms.TabPage();
            this.txtTraceMsgs = new System.Windows.Forms.TextBox();
            this.fraDescription = new System.Windows.Forms.GroupBox();
            this.SLIKServer1 = new NDI.SLIKDA.Interop.SLIKServer();
            this.imgCert = new System.Windows.Forms.PictureBox();
            this.lblDescription = new System.Windows.Forms.Label();
            this.tmrTagUpdate = new System.Windows.Forms.Timer(this.components);
            this.tabMain.SuspendLayout();
            this._tabMain_TabPage0.SuspendLayout();
            this._tabMain_TabPage1.SuspendLayout();
            this.fraDescription.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.SLIKServer1)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.imgCert)).BeginInit();
            this.SuspendLayout();
            // 
            // tmrMain
            // 
            this.tmrMain.Interval = 1000;
            this.tmrMain.Tick += new System.EventHandler(this.tmrMain_Tick);
            // 
            // MainMenu1
            // 
            this.MainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuFile,
            this.mnuEdit,
            this.mnuTrace,
            this.mnuHelp});
            // 
            // mnuFile
            // 
            this.mnuFile.Index = 0;
            this.mnuFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuFileClientDisc,
            this.mnuFileSep1,
            this.mnuFileForceExit,
            this.mnuFileSep2,
            this.mnuFileExit});
            this.mnuFile.Text = "&File";
            // 
            // mnuFileClientDisc
            // 
            this.mnuFileClientDisc.Index = 0;
            this.mnuFileClientDisc.Text = "&Request Clients To Disconnect";
            this.mnuFileClientDisc.Popup += new System.EventHandler(this.mnuFileClientDisc_Popup);
            this.mnuFileClientDisc.Click += new System.EventHandler(this.mnuFileClientDisc_Click);
            // 
            // mnuFileSep1
            // 
            this.mnuFileSep1.Index = 1;
            this.mnuFileSep1.Text = "-";
            // 
            // mnuFileForceExit
            // 
            this.mnuFileForceExit.Index = 2;
            this.mnuFileForceExit.Text = "&Force Server Exit";
            this.mnuFileForceExit.Popup += new System.EventHandler(this.mnuFileForceExit_Popup);
            this.mnuFileForceExit.Click += new System.EventHandler(this.mnuFileForceExit_Click);
            // 
            // mnuFileSep2
            // 
            this.mnuFileSep2.Index = 3;
            this.mnuFileSep2.Text = "-";
            // 
            // mnuFileExit
            // 
            this.mnuFileExit.Index = 4;
            this.mnuFileExit.Text = "E&xit";
            this.mnuFileExit.Popup += new System.EventHandler(this.mnuFileExit_Popup);
            this.mnuFileExit.Click += new System.EventHandler(this.mnuFileExit_Click);
            // 
            // mnuEdit
            // 
            this.mnuEdit.Index = 1;
            this.mnuEdit.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuEditStatPeriod});
            this.mnuEdit.Text = "&Edit";
            // 
            // mnuEditStatPeriod
            // 
            this.mnuEditStatPeriod.Index = 0;
            this.mnuEditStatPeriod.Text = "Statistics Sample &Period ...";
            this.mnuEditStatPeriod.Popup += new System.EventHandler(this.mnuEditStatPeriod_Popup);
            this.mnuEditStatPeriod.Click += new System.EventHandler(this.mnuEditStatPeriod_Click);
            // 
            // mnuTrace
            // 
            this.mnuTrace.Index = 2;
            this.mnuTrace.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuTraceNone,
            this.mnuTraceConnect,
            this.mnuTraceGroup,
            this.mnuTraceItem,
            this.mnuTraceAll,
            this.mnuTraceSep1,
            this.mnuTraceClear,
            this.mnuTraceSep2,
            this.mnuTraceCOM});
            this.mnuTrace.Text = "&Trace";
            // 
            // mnuTraceNone
            // 
            this.mnuTraceNone.Checked = true;
            this.mnuTraceNone.Index = 0;
            this.mnuTraceNone.Text = "&None";
            this.mnuTraceNone.Popup += new System.EventHandler(this.mnuTraceNone_Popup);
            this.mnuTraceNone.Click += new System.EventHandler(this.mnuTraceNone_Click);
            // 
            // mnuTraceConnect
            // 
            this.mnuTraceConnect.Index = 1;
            this.mnuTraceConnect.Text = "&Connect";
            this.mnuTraceConnect.Popup += new System.EventHandler(this.mnuTraceConnect_Popup);
            this.mnuTraceConnect.Click += new System.EventHandler(this.mnuTraceConnect_Click);
            // 
            // mnuTraceGroup
            // 
            this.mnuTraceGroup.Index = 2;
            this.mnuTraceGroup.Text = "&Group";
            this.mnuTraceGroup.Popup += new System.EventHandler(this.mnuTraceGroup_Popup);
            this.mnuTraceGroup.Click += new System.EventHandler(this.mnuTraceGroup_Click);
            // 
            // mnuTraceItem
            // 
            this.mnuTraceItem.Index = 3;
            this.mnuTraceItem.Text = "&Item";
            this.mnuTraceItem.Popup += new System.EventHandler(this.mnuTraceItem_Popup);
            this.mnuTraceItem.Click += new System.EventHandler(this.mnuTraceItem_Click);
            // 
            // mnuTraceAll
            // 
            this.mnuTraceAll.Index = 4;
            this.mnuTraceAll.Text = "&All";
            this.mnuTraceAll.Popup += new System.EventHandler(this.mnuTraceAll_Popup);
            this.mnuTraceAll.Click += new System.EventHandler(this.mnuTraceAll_Click);
            // 
            // mnuTraceSep1
            // 
            this.mnuTraceSep1.Index = 5;
            this.mnuTraceSep1.Text = "-";
            // 
            // mnuTraceClear
            // 
            this.mnuTraceClear.Index = 6;
            this.mnuTraceClear.Text = "C&lear Messages";
            this.mnuTraceClear.Popup += new System.EventHandler(this.mnuTraceClear_Popup);
            this.mnuTraceClear.Click += new System.EventHandler(this.mnuTraceClear_Click);
            // 
            // mnuTraceSep2
            // 
            this.mnuTraceSep2.Index = 7;
            this.mnuTraceSep2.Text = "-";
            // 
            // mnuTraceCOM
            // 
            this.mnuTraceCOM.Index = 8;
            this.mnuTraceCOM.Text = "&Enable COM Call Tracing";
            this.mnuTraceCOM.Popup += new System.EventHandler(this.mnuTraceCOM_Popup);
            this.mnuTraceCOM.Click += new System.EventHandler(this.mnuTraceCOM_Click);
            // 
            // mnuHelp
            // 
            this.mnuHelp.Index = 3;
            this.mnuHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuHelpAbout});
            this.mnuHelp.Text = "&Help";
            // 
            // mnuHelpAbout
            // 
            this.mnuHelpAbout.Index = 0;
            this.mnuHelpAbout.Text = "&About ...";
            this.mnuHelpAbout.Popup += new System.EventHandler(this.mnuHelpAbout_Popup);
            this.mnuHelpAbout.Click += new System.EventHandler(this.mnuHelpAbout_Click);
            // 
            // tabMain
            // 
            this.tabMain.Controls.Add(this._tabMain_TabPage0);
            this.tabMain.Controls.Add(this._tabMain_TabPage1);
            this.tabMain.Dock = System.Windows.Forms.DockStyle.Top;
            this.tabMain.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.tabMain.ItemSize = new System.Drawing.Size(42, 18);
            this.tabMain.Location = new System.Drawing.Point(0, 0);
            this.tabMain.Multiline = true;
            this.tabMain.Name = "tabMain";
            this.tabMain.Padding = new System.Drawing.Point(0, 0);
            this.tabMain.SelectedIndex = 0;
            this.tabMain.Size = new System.Drawing.Size(592, 240);
            this.tabMain.TabIndex = 5;
            // 
            // _tabMain_TabPage0
            // 
            this._tabMain_TabPage0.Controls.Add(this.lvStats);
            this._tabMain_TabPage0.Location = new System.Drawing.Point(4, 22);
            this._tabMain_TabPage0.Name = "_tabMain_TabPage0";
            this._tabMain_TabPage0.Size = new System.Drawing.Size(584, 214);
            this._tabMain_TabPage0.TabIndex = 0;
            this._tabMain_TabPage0.Text = "Statistics";
            // 
            // lvStats
            // 
            this.lvStats.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2});
            this.lvStats.Dock = System.Windows.Forms.DockStyle.Fill;
            this.lvStats.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lvStats.GridLines = true;
            this.lvStats.Location = new System.Drawing.Point(0, 0);
            this.lvStats.Name = "lvStats";
            this.lvStats.Size = new System.Drawing.Size(584, 214);
            this.lvStats.TabIndex = 0;
            this.lvStats.UseCompatibleStateImageBehavior = false;
            this.lvStats.View = System.Windows.Forms.View.Details;
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Statistic";
            this.columnHeader1.Width = 290;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Value";
            this.columnHeader2.Width = 100;
            // 
            // _tabMain_TabPage1
            // 
            this._tabMain_TabPage1.Controls.Add(this.txtTraceMsgs);
            this._tabMain_TabPage1.Location = new System.Drawing.Point(4, 22);
            this._tabMain_TabPage1.Name = "_tabMain_TabPage1";
            this._tabMain_TabPage1.Size = new System.Drawing.Size(584, 214);
            this._tabMain_TabPage1.TabIndex = 1;
            this._tabMain_TabPage1.Text = "Trace Messages";
            this._tabMain_TabPage1.Visible = false;
            // 
            // txtTraceMsgs
            // 
            this.txtTraceMsgs.AcceptsReturn = true;
            this.txtTraceMsgs.BackColor = System.Drawing.SystemColors.Window;
            this.txtTraceMsgs.Cursor = System.Windows.Forms.Cursors.IBeam;
            this.txtTraceMsgs.Dock = System.Windows.Forms.DockStyle.Fill;
            this.txtTraceMsgs.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtTraceMsgs.ForeColor = System.Drawing.SystemColors.WindowText;
            this.txtTraceMsgs.Location = new System.Drawing.Point(0, 0);
            this.txtTraceMsgs.MaxLength = 0;
            this.txtTraceMsgs.Multiline = true;
            this.txtTraceMsgs.Name = "txtTraceMsgs";
            this.txtTraceMsgs.RightToLeft = System.Windows.Forms.RightToLeft.No;
            this.txtTraceMsgs.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.txtTraceMsgs.Size = new System.Drawing.Size(584, 214);
            this.txtTraceMsgs.TabIndex = 5;
            // 
            // fraDescription
            // 
            this.fraDescription.BackColor = System.Drawing.SystemColors.Control;
            this.fraDescription.Controls.Add(this.SLIKServer1);
            this.fraDescription.Controls.Add(this.imgCert);
            this.fraDescription.Controls.Add(this.lblDescription);
            this.fraDescription.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.fraDescription.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.fraDescription.ForeColor = System.Drawing.SystemColors.ControlText;
            this.fraDescription.Location = new System.Drawing.Point(0, 226);
            this.fraDescription.Name = "fraDescription";
            this.fraDescription.RightToLeft = System.Windows.Forms.RightToLeft.No;
            this.fraDescription.Size = new System.Drawing.Size(592, 83);
            this.fraDescription.TabIndex = 6;
            this.fraDescription.TabStop = false;
            // 
            // SLIKServer1
            // 
            this.SLIKServer1.Enabled = true;
            this.SLIKServer1.Location = new System.Drawing.Point(428, 45);
            this.SLIKServer1.Name = "SLIKServer1";
            this.SLIKServer1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("SLIKServer1.OcxState")));
            this.SLIKServer1.Size = new System.Drawing.Size(32, 32);
            this.SLIKServer1.TabIndex = 3;
            this.SLIKServer1.OnWrite += new NDI.SLIKDA.Interop.SLIKServer.OnWriteEventHandler(this.SLIKServer1_OnWrite);
            this.SLIKServer1.OnWriteVQT += new NDI.SLIKDA.Interop.SLIKServer.OnWriteVQTEventHandler(this.SLIKServer1_OnWriteVQT);
            this.SLIKServer1.OnRead += new NDI.SLIKDA.Interop.SLIKServer.OnReadEventHandler(this.SLIKServer1_OnRead);
            this.SLIKServer1.OnTrace += new NDI.SLIKDA.Interop.SLIKServer.OnTraceEventHandler(this.SLIKServer1_OnTrace);
            // 
            // imgCert
            // 
            this.imgCert.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.imgCert.Cursor = System.Windows.Forms.Cursors.Default;
            this.imgCert.Image = ((System.Drawing.Image)(resources.GetObject("imgCert.Image")));
            this.imgCert.Location = new System.Drawing.Point(480, 9);
            this.imgCert.Name = "imgCert";
            this.imgCert.Size = new System.Drawing.Size(104, 70);
            this.imgCert.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.imgCert.TabIndex = 1;
            this.imgCert.TabStop = false;
            // 
            // lblDescription
            // 
            this.lblDescription.BackColor = System.Drawing.SystemColors.Control;
            this.lblDescription.Cursor = System.Windows.Forms.Cursors.Default;
            this.lblDescription.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblDescription.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblDescription.Location = new System.Drawing.Point(6, 16);
            this.lblDescription.Name = "lblDescription";
            this.lblDescription.RightToLeft = System.Windows.Forms.RightToLeft.No;
            this.lblDescription.Size = new System.Drawing.Size(474, 65);
            this.lblDescription.TabIndex = 2;
            this.lblDescription.Text = resources.GetString("lblDescription.Text");
            // 
            // tmrTagUpdate
            // 
            this.tmrTagUpdate.Enabled = true;
            this.tmrTagUpdate.Interval = 1000;
            this.tmrTagUpdate.Tick += new System.EventHandler(this.tmrTagUpdate_Tick);
            // 
            // frmMain
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(592, 309);
            this.Controls.Add(this.fraDescription);
            this.Controls.Add(this.tabMain);
            this.Font = new System.Drawing.Font("Arial", 8F);
            this.Location = new System.Drawing.Point(11, 30);
            this.Menu = this.MainMenu1;
            this.Name = "frmMain";
            this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            this.Text = "C# Advanced OPC Server";
            this.Load += new System.EventHandler(this.frmMain_Load);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.frmMain_Closing);
            this.Resize += new System.EventHandler(this.frmMain_Resize);
            this.tabMain.ResumeLayout(false);
            this._tabMain_TabPage0.ResumeLayout(false);
            this._tabMain_TabPage1.ResumeLayout(false);
            this._tabMain_TabPage1.PerformLayout();
            this.fraDescription.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.SLIKServer1)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.imgCert)).EndInit();
            this.ResumeLayout(false);

		}

		[STAThread]
		static void Main() 
		{
			//Throws an exception if Close() is called in Load
			//i.e. /regserver or /unregserver is specified
			try
			{
				Application.Run( new frmMain() );
			}
			catch{}
		}
		#endregion

		public string m_sAppName;
	
		// Maximum size (in characters) of all messages in the Trace Window.
		private const int c_nMaxTraceViewLen = 30000;
	
		// Flag indicating message destination for ReportEvent method. Set this flag as
		// follows:
		//   true - Display message in popup dialog.
		//   false - Log message to trace window. Use this setting to prevent popup dialogs
		//       when running the server in the background.
		private bool c_bUseMsgBox = false;

		// Flag indicating whether the //Force Server Exit// option has been selected
		private bool m_bForceExit = false;

		//********************************************************************************
		// Description:      Log a debug message to the trace window.
		//
		// Parameters:
		//   In:             sMsg  The debug message.
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void LogDebugMessage(string sMsg)
		{
			LogTraceMessage("DEBUG (" + sMsg + ")" );
		}

		//********************************************************************************
		// Description:      Log a message to the trace window.
		//
		// Parameters:
		//   In:             sMsg  The trace message.
		//
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void LogTraceMessage(string sMsg)
		{
			//
			// Format the message for the trace window.
			//
			string sTemp;
			CultureInfo ci = new CultureInfo( "es-ES" );
			sTemp = System.DateTime.Now.ToString( "T", ci ) + " " + 
					sMsg + System.Environment.NewLine;
		
			if( txtTraceMsgs.Text.Length  > c_nMaxTraceViewLen )
			{
				// Make room for more messages
				int nPos = txtTraceMsgs.Text.IndexOf( 
												"\n",
												(int) (c_nMaxTraceViewLen * 0.25)
												);
				if( nPos > 0 )
					txtTraceMsgs.Text = txtTraceMsgs.Text.Substring( nPos + 1 );
			}

			//
			// Append message in the trace window
			//
			txtTraceMsgs.SelectionStart = txtTraceMsgs.Text.Length;
			txtTraceMsgs.SelectedText = sTemp;
		}

		
		//********************************************************************************
		// Description:      Either display a message box for the given message, or log the
		//                   message to the trace window.
		//
		// Parameters:
		//   In:             sMsg  The trace message.
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		public void ReportEvent(string sPrompt, string sTitle)
		{
			if( c_bUseMsgBox )
			{
				MessageBox.Show( sPrompt, sTitle , MessageBoxButtons.OK );
			}
			else
			{
				LogDebugMessage( sTitle + ": " + sPrompt );									  
			}
		}	

		//********************************************************************************
		// Description:      Initialize the statistics window with the list of server
		//                   statistics. Create a entry (row) for each statistic.
		//
		// Parameters:
		//   In:             None
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void InitializeStatsView()
		{
			lvStats.GridLines = true;
			lvStats.Items.Add( "Sample Period (ms)" );
			lvStats.Items[ CSlikUtil.c_nStatSamplePeriod ].SubItems.Add( "" );
			lvStats.Items.Add( "Number of Clients" );
			lvStats.Items[ CSlikUtil.c_nStatClients ].SubItems.Add( "" );
			lvStats.Items.Add( "Number of Groups" );
			lvStats.Items[ CSlikUtil.c_nStatGroups ].SubItems.Add( "" );
			lvStats.Items.Add( "Number of Items" );
			lvStats.Items[ CSlikUtil.c_nStatItems ].SubItems.Add( "" );
			lvStats.Items.Add( "Number of Reads (last sample period)" );
			lvStats.Items[ CSlikUtil.c_nStatReads ].SubItems.Add( "" );
			lvStats.Items.Add( "Number of Writes (last sample period)" );
			lvStats.Items[ CSlikUtil.c_nStatWrites ].SubItems.Add( "" );
			lvStats.Items.Add( "Number of Change Notifications (last sample period)" );
			lvStats.Items[ CSlikUtil.c_nStatChanges ].SubItems.Add( "" );		
			
			UpdateStatsView();
		}

		//********************************************************************************
		// Description:      Update the statistics window with the current value of each
		//                   server statistic.
		//
		// Parameters:
		//   In:             None
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void UpdateStatsView()
		{
			try
			{
				ISLIKStatistics Stats;
				Stats = SLIKServer1.SLIKStatistics;
				//
				// Note: Use either numeric or string constants (see module CSlikUtil) to
				// reference each statistic.
				//
				lvStats.Items[CSlikUtil.c_nStatSamplePeriod].SubItems[1].Text  = 
					(string) "" + Stats[ (int) StatsIndexEnum.sdaSamplePeriod ];
				lvStats.Items[CSlikUtil.c_nStatClients].SubItems[1].Text = 
					(string) "" + Stats[ (int) StatsIndexEnum.sdaNumClients ];
				lvStats.Items[CSlikUtil.c_nStatGroups].SubItems[1].Text = 
					(string) "" + Stats[ (int) StatsIndexEnum.sdaNumGroups ];
				lvStats.Items[CSlikUtil.c_nStatItems].SubItems[1].Text = 
					(string) "" + Stats[ (int) StatsIndexEnum.sdaNumItems ];
				lvStats.Items[CSlikUtil.c_nStatReads].SubItems[1].Text = 
					(string) "" + Stats[ (int) StatsIndexEnum.sdaNumReadsPerPeriod ];
				lvStats.Items[CSlikUtil.c_nStatWrites].SubItems[1].Text = 
					(string) "" + Stats[ (int) StatsIndexEnum.sdaNumWritesPerPeriod ];
				lvStats.Items[CSlikUtil.c_nStatChanges].SubItems[1].Text = 
					(string) "" + Stats[ (int) StatsIndexEnum.sdaNumChgPerPeriod];
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message , "Update Statistics View Error");
				return;
			}
		}	

		//********************************************************************************
		// Description:      Update the main menu tracing options, so that only one option
		//                   is selected (checked).
		//
		// Parameters:
		//   In:             TraceLevel  The user-selected trace level.
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void UpdateTraceOptions(
			TraceLevelEnum TraceLevel
			)
		{

			mnuTraceNone.Checked = false;
			mnuTraceConnect.Checked = false;
			mnuTraceGroup.Checked = false;
			mnuTraceItem.Checked = false;
			mnuTraceAll.Checked = false;

			if( TraceLevel == TraceLevelEnum.sdaTraceLevelNone)
				mnuTraceNone.Checked = true;
			else if( TraceLevel == TraceLevelEnum.sdaTraceLevelConnect )
				mnuTraceConnect.Checked = true;
			else if( TraceLevel == TraceLevelEnum.sdaTraceLevelGroup )
				mnuTraceGroup.Checked = true;
			else if( TraceLevel == TraceLevelEnum.sdaTraceLevelItem )
				mnuTraceItem.Checked = true;
			else if( TraceLevel == TraceLevelEnum.sdaTraceLevelAll )
				mnuTraceAll.Checked = true;
		}

		//********************************************************************************
		// Description:      Initialize the application.
		//********************************************************************************
		private void frmMain_Load( 
			System.Object eventSender, 
			System.EventArgs eventArgs
			)
		{
			bool bExit;
			bExit = false;

			try
			{
				//
				// Initialize the main form properties
				//
				this.Text = "C# Advanced OPC Server";
				m_bForceExit = false;

				m_sAppName = "Software Toolbox's " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Name;
				
				// Get the command line arguments to check for server registration switches
				string sCmdLine = System.Environment.CommandLine;

				//
				// Perform server registration as required.
				//
				// NOTE: Case-sensitive comparison
				if( sCmdLine.IndexOf( "unregserver", 0) > 0 )
				{
					SLIKServer1.UnregisterServer();
					bExit = true;
				}
				else if( sCmdLine.IndexOf("regserver", 0) > 0 )
				{
					SLIKServer1.RegisterServer();
					bExit = true;
				}
				// ignore any other switches
			
				if( bExit )
				{
					// If a server registration switch was specified in the command line, the
					// standard COM server behaviour is to exit immediately after changing the
					// registration information.
					m_bForceExit = true;
					this.Close();
					return;
				}

				//
				// Start the server with the pre-defined namespace
				//
				if( !CSlikUtil.InitNamespace( ref SLIKServer1, this ) )
				{
					m_bForceExit = true;
					this.Close();
					return;
				}
				SLIKServer1.StartServer();

				//
				// Initialize the statistics tab
				//
				InitializeStatsView();

				//
				// Start the periodic update of the statistics window and the tag cache.
				//
				tmrMain.Enabled = true;
	
				//
				// Initialize the trace message logging.
				// NOTE: For this sample application, always log trace message to the trace window.
				//
				TraceLevelEnum eTraceLevel = TraceLevelEnum.sdaTraceLevelNone;
				SLIKServer1.SetTraceInfo( 
					eTraceLevel, 
					TraceDestEnum.sdaTraceToEvent, 
					DefaultValues.SetTraceInfo_TraceFileName, 
					DefaultValues.SetTraceInfo_MaxFileSize
					);
				UpdateTraceOptions( eTraceLevel );
 
				// DEBUG
				LogDebugMessage("Server initialization completed.");
				return;
			}
			catch( System.Exception e)
			{
				ReportEvent(e.Message , "Startup Error");
				m_bForceExit = true;
				this.Close();
				return;
			}
		}

		//********************************************************************************
		// Description:      Ensure that one of the following is true before exiting:
		//                   1) No client connections to this server exist
		//                   2) The user has selected the "Force Server Exit" option
		//
		// Parameters:
		//   In:             UnloadMode  cause of the QueryUnload event
		//
		//   Out:            Cancel      if non-zero, do NOT proceed with exit
		//
		// Return Value:     None
		//********************************************************************************
		private void frmMain_Closing( System.Object eventSender, System.ComponentModel.CancelEventArgs eventArgs )
		{																						
			bool Cancel = false;
			string sMsg;

			if (SLIKServer1.InUse && !m_bForceExit )
			{
				// Cancel the shutdown
				Cancel = true;
				sMsg =	"The server is unable to shutdown at this time. " + 
					"There are still clients connected. " + 
					"If required, use the 'Force Server Exit' option.";
				ReportEvent( sMsg, this.Text );
			}

			// Stop the periodic update of the statistics window.
			tmrMain.Enabled = true;

			// NOTE: When the SLIKServer object goes out of scope, it will clean up any remaining
			// connections, groups, and items.
			eventArgs.Cancel = Cancel;
		}

		//********************************************************************************
		// Description:      Update the position and size of the controls on the main form.
		//********************************************************************************
		private void frmMain_Resize( System.Object eventSender, System.EventArgs eventArgs )
		{
			int iTabCtrlHeight;
			int iTabPaneHeight;
			int iDescrLblWidth;

			if( WindowState == System.Windows.Forms.FormWindowState.Minimized ) 
			{
				//do nothing - to prevent scrunching controls
			}
			else
			{
				tabMain.Left = this.Left;
				fraDescription.Left = this.Left;

				tabMain.Width = ClientRectangle.Width;
				fraDescription.Width = ClientRectangle.Width;

				imgCert.Left = ClientRectangle.Width - imgCert.Width - 5;
			}

			lvStats.Width = tabMain.Width - 40;
			txtTraceMsgs.Width = tabMain.Width - 40;

			iTabCtrlHeight = ClientRectangle.Height - fraDescription.Height;
			if( iTabCtrlHeight > 0 )
			{
				tabMain.Top = (this.Top );
				tabMain.Height = iTabCtrlHeight;
				fraDescription.Top = iTabCtrlHeight;
				iTabPaneHeight = iTabCtrlHeight - tabMain.ItemSize.Height - 20;
				if( iTabPaneHeight > 0 )
				{
					lvStats.Height = iTabPaneHeight;
					txtTraceMsgs.Height = iTabPaneHeight;
				}
			}
			else
			{
				tabMain.Height = 0;
				fraDescription.Top = this.Top;
			}
		}


		//********************************************************************************
		// Description:      Display application and company information.
		//********************************************************************************
		private void imgLogo_DoubleClick( System.Object eventSender, System.EventArgs eventArgs )
		{
			frmAbout f = new frmAbout();
			f.ShowDialog(this);
		}		
		
		//********************************************************************************
		// Description:      Modify the sample period (in milliseconds) that the toolkit
		//                   will use while collecting time-based statistics (e.g. number
		//                   of reads per period).
		//********************************************************************************
		public void mnuEditStatPeriod_Popup( System.Object eventSender , System.EventArgs eventArgs )
		{
			mnuEditStatPeriod_Click(eventSender, eventArgs);
		}
		private void mnuEditStatPeriod_Click( System.Object eventSender, System.EventArgs eventArgs )
		{
			try
			{
				frmEditSP f = new frmEditSP();
				f.m_nStatSamplePeriod = SLIKServer1.StatsSamplePeriod;
				f.ShowDialog( this );
				SLIKServer1.StatsSamplePeriod = f.m_nStatSamplePeriod;
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message, "Statistics Period Update Error");
			}
		}

		//********************************************************************************
		// Description:      Issues a request to all OPC clients to release all connections
		//                   to this server.
		//
		//                   NOTE: Only V2.0 compliant clients would receive this request,
		//                   as this functionality was introduced in version 2.0 of the OPC
		//                   Data Access Standard.
		//********************************************************************************
		public void mnuFileClientDisc_Popup( System.Object eventSender , System.EventArgs eventArgs) 
		{
			mnuFileClientDisc_Click(eventSender, eventArgs);
		}
		public void mnuFileClientDisc_Click( System.Object eventSender , System.EventArgs eventArgs )
		{
			try
			{
				SLIKServer1.RequestDisconnect( "Server shutdown in 1 minute..." );
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message , "Request Disconnect Error");
			}
		}

		//********************************************************************************
		// Description:      Exit if no clients connections to this server exist.
		//********************************************************************************
		public void mnuFileExit_Popup( System.Object eventSender, System.EventArgs eventArgs )
		{
			mnuFileExit_Click(eventSender, eventArgs);
		}
		public void mnuFileExit_Click( System.Object eventSender, System.EventArgs eventArgs )
		{
			this.Close();
		}

		//********************************************************************************
		// Description:      Force this server to exit, even if clients are still connected.
		//
		//                   NOTE: Use of this feature may cause unpredictable behaviour in
		//                   certain clients. Use with caution.
		//********************************************************************************
		public void mnuFileForceExit_Popup( System.Object eventSender, System.EventArgs eventArgs )
		{
			mnuFileForceExit_Click( eventSender, eventArgs );
		}
		public void mnuFileForceExit_Click( System.Object eventSender , System.EventArgs eventArgs )
		{
			m_bForceExit = true;
			this.Close();
		}

		//********************************************************************************
		// Description:      Display application and company information.
		//********************************************************************************
		public void mnuHelpAbout_Popup( System.Object eventSender, System.EventArgs eventArgs )
		{
			mnuHelpAbout_Click(eventSender, eventArgs);
		}
		public void mnuHelpAbout_Click( System.Object eventSender, System.EventArgs eventArgs )
		{
			frmAbout f = new frmAbout();
			f.ShowDialog(this);
		}

		//********************************************************************************
		// Description:      Log all trace message types.
		//********************************************************************************
		public void mnuTraceAll_Popup(System.Object eventSender, System.EventArgs eventArgs ) 
		{																									  
			mnuTraceAll_Click(eventSender, eventArgs);
		}
		public void mnuTraceAll_Click(System.Object eventSender, System.EventArgs eventArgs )
		{
			try
			{
				// update the SLIK server
				SLIKServer1.SetTraceInfo(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelAll,DefaultValues.SetTraceInfo_TraceDest , DefaultValues.SetTraceInfo_TraceFileName,DefaultValues.SetTraceInfo_MaxFileSize  );

				// update the main menu options
				UpdateTraceOptions(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelAll);
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message, "Trace Level Update Error");
			}
		}

		//********************************************************************************
		// Description:      Log trace messages associated with client connectivity and
		//                   server activation.
		//********************************************************************************
		public void mnuTraceConnect_Popup(System.Object eventSender ,System.EventArgs eventArgs )
		{																									  
			mnuTraceConnect_Click(eventSender, eventArgs);
		}
		public void mnuTraceConnect_Click(System.Object eventSender, System.EventArgs eventArgs )
		{
			try
			{
				// update the SLIK server
				SLIKServer1.SetTraceInfo(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelConnect,DefaultValues.SetTraceInfo_TraceDest , DefaultValues.SetTraceInfo_TraceFileName,DefaultValues.SetTraceInfo_MaxFileSize  );

				// update the main menu options
				UpdateTraceOptions(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelConnect);
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message, "Trace Level Update Error");
			}
		}

		//********************************************************************************
		// Description:      Log trace messages associated with creating, deleting, or
		//                   modifying OPC groups.
		//********************************************************************************
		public void mnuTraceGroup_Popup(System.Object eventSender ,System.EventArgs eventArgs )
		{																									  
			mnuTraceGroup_Click(eventSender, eventArgs);
		}
		public void mnuTraceGroup_Click(System.Object eventSender, System.EventArgs eventArgs ) 
		{
			try
			{
				// update the SLIK server
				SLIKServer1.SetTraceInfo(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelGroup,DefaultValues.SetTraceInfo_TraceDest , DefaultValues.SetTraceInfo_TraceFileName,DefaultValues.SetTraceInfo_MaxFileSize  );

				// update the main menu options
				UpdateTraceOptions(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelGroup);
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message, "Trace Level Update Error");
			}
		}

		//********************************************************************************
		// Description:      Log trace messages associated with item transactions.
		//                   For example, read, write, and subscription transactions.
		//********************************************************************************
		public void mnuTraceItem_Popup(System.Object eventSender ,System.EventArgs eventArgs ) 
		{																									  
			mnuTraceItem_Click(eventSender, eventArgs);
		}
		public void mnuTraceItem_Click(System.Object eventSender, System.EventArgs eventArgs ) 
		{
			try
			{
				// update the SLIK server
				SLIKServer1.SetTraceInfo(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelItem,DefaultValues.SetTraceInfo_TraceDest , DefaultValues.SetTraceInfo_TraceFileName,DefaultValues.SetTraceInfo_MaxFileSize  );

				// update the main menu options
				UpdateTraceOptions(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelItem);
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message, "Trace Level Update Error");
			}
		}

		//********************************************************************************
		// Description:      Turn off internal SLIK server tracing.
		//********************************************************************************
		public void mnuTraceNone_Popup( System.Object eventSender, System.EventArgs eventArgs ) 
		{																									  
			mnuTraceItem_Click(eventSender, eventArgs);
		}
		public void mnuTraceNone_Click( System.Object eventSender, System.EventArgs eventArgs )
		{
			try
			{
				// update the SLIK server
				SLIKServer1.SetTraceInfo(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelNone,DefaultValues.SetTraceInfo_TraceDest , DefaultValues.SetTraceInfo_TraceFileName,DefaultValues.SetTraceInfo_MaxFileSize  );

				// update the main menu options
				UpdateTraceOptions(NDI.SLIKDA.Interop.TraceLevelEnum.sdaTraceLevelNone);
				return;
			}
			catch( System.Exception e )
			{
				ReportEvent(e.Message, "Trace Level Update Error");
			}
		}

		//********************************************************************************
		// Description:      Clear the contents of the trace message tab.
		//********************************************************************************
		public void mnuTraceClear_Popup( System.Object eventSender, System.EventArgs eventArgs ) 
		{
			mnuTraceClear_Click( eventSender, eventArgs );
		}
		public void mnuTraceClear_Click( System.Object eventSender, System.EventArgs eventArgs )
		{
			txtTraceMsgs.Text = "";
		}

		//********************************************************************************
		// Description:      Toggle logging of COM trace messages.
		//********************************************************************************
		public void mnuTraceCOM_Popup( System.Object eventSender, System.EventArgs eventArgs )
		{
			mnuTraceCOM_Click(eventSender, eventArgs);
		}
		public void mnuTraceCOM_Click( System.Object eventSender, System.EventArgs eventArgs ) 
		{
			try
			{
				//determine the new state
				mnuTraceCOM.Checked = !mnuTraceCOM.Checked;

				//update the SLIK server
				SLIKServer1.COMCallTracingEnabled = mnuTraceCOM.Checked;
				return;
			}
			catch(Exception e)
			{
				ReportEvent(e.Message, "COM Trace Toggle Error");
			}
		}

		//********************************************************************************
		// Description:	This event is fired whenever an OPC client has requested a
		//				device read for one or more tags.
		//                   
		//				NOTE: A handler should always be provided for this event!
		//
		// Parameters:
		//   In:	sender	-	the SLIKServer object that fired the event
		//			eventArgs -	an System.EventArgs derived object that contains the
		//						following members:
		//
		//						Count       Number of items in the Tags array.
		//						Tags        Array of items to read.
		//						AccessPaths Array of requested access paths.
		//									Note: This server does not support access paths.
		// 						Errors		Array of item-level error codes.
		//							sdaSOK -	The corresponding tag was read 
		//										successfully. That tags value, 
		//										quality, and timestamp was updated.
		//							sdaEFail -	The read operation for the corresponding 
		//										tag failed.
		//						Result		 The overall result of the operation.
		//							sdaSOK	-	All tags were read successfully. Each 
		//										tags value, quality, and timestamp 
		//										was updated. All entries in the Errors 
		//										array are sdaSOK.
		//							sdaSFalse -	The operation succeeded, but one or 
		//										more elements in the Errors array 
		//										contains an error value.
		//							sdaEFail -	The operation as a whole failed.
		//	Out:	None
		//
		//	Return Values:	None
		//********************************************************************************
		private void SLIKServer1_OnRead(
			object sender, 
			NDI.SLIKDA.Interop.SLIKServer.OnReadEventArgs eventArgs)
		{
			try
			{
				CSimulate.ReadTags( 
					eventArgs.Count, 
					eventArgs.Tags, 
					eventArgs.Errors, 
					ref eventArgs.Result
					);
			}
			catch( System.Exception e)
			{
				ReportEvent(e.Message , "OnRead Event Error");
				eventArgs.Result = (int)OPCDAErrorsEnum.sdaEFail;
			}
		}

		//********************************************************************************
		// Description:	This event is fired whenever an OPC client has issued a 
		//				request to write new values to one or more tags.
		//
		//				NOTE: A handler should always be provided for this event!
		//
		// Parameters:
		//   In:	sender	-	the SLIKServer object that fired the event
		//			eventArgs -	an System.EventArgs derived object that contains the
		//						following members:
		//
		//						Count       Number of items in the Tags array.
		//						Tags        Array of items to write.
		//						AccessPaths Array of requested access paths.
		//									Note: This server does not support access paths.
		//						Values      Array of values to be written to each item.
		//						Errors      Array of item-level return codes. Possible values
		//									for each element include:
		//							sdaSOK -	The corresponding tag was written successfully.
		//										That tags value, quality, and timestamp 
		//										was updated.
		//							sdaSClamp -	The corresponding tag was written 
		//										successfully, but was clamped.
		//							sdaERange -	The value was out of range. It was 
		//										not written to the tag.
		//							sdaEFail -	The write operation for the corresponding 
		//										tag failed.
		//						Result		 The overall result of the operation.
		//							sdaSOK -	All tags were written successfully. Each 
		//										tags value, quality, and timestamp was 
		//										updated. All entries in the Errors array 
		//										are sdaSOK.
		//							sdaSFalse -	The operation succeeded, but one or more 
		//										elements in the Errors array contains an 
		//										error value.
		//							sdaEFail -	The operation as a whole failed.
		//
		//	Out:	None
		//
		//	Return Values:	None
		//********************************************************************************
		private void SLIKServer1_OnWrite(
			object sender, 
			NDI.SLIKDA.Interop.SLIKServer.OnWriteEventArgs eventArgs)
		{																																						   //UPGRADE_NOTE: Tag was upgraded to Tag_Renamed. Click for more: //ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1061"//
			try
			{
				short[]	Qualities = {};
				System.DateTime[] Timestamps = {};

				CSimulate.WriteTags( 
					eventArgs.Count,
					eventArgs.Tags, 
					eventArgs.Values,
					Qualities,
					Timestamps,
					eventArgs.Errors, 
					ref eventArgs.Result
					);
			}
			catch( System.Exception e )
			{
				ReportEvent( e.Message , "OnWrite Event Error" );
				eventArgs.Result = (int) OPCDAErrorsEnum.sdaEFail;
			}
		}
		
		//********************************************************************************
		// Description:	This event is fired whenever an OPC client has issued a 
		//				request to write new values, qualities or timestamps to one 
		//              or more tags.
		//
		//				NOTE: This handler is optional.
		//
		// Parameters:
		//   In:	sender	-	the SLIKServer object that fired the event
		//			eventArgs -	an System.EventArgs derived object that contains the
		//						following members:
		//
		//						Count       Number of items in the Tags array.
		//						Tags        Array of tags to write.
		//						AccessPaths Array of requested access paths.
		//									Note: This server does not support access paths.
		//						Values      Array of values to be written. If an
		//							        entry contains an empty variant then a value is
		//								    not to be written to the corresponding tag.
		//						Qualities   Array of qualities to be written. If an
		//									entry contains -1 then the quality is
		//									not to be written to the corresponding tag.
		//						Timestamps  Array of timestamps to be written. If an
		//									entry contains a 0 then a timestamp is
		//									not to be written to the corresponding tag.
		//						Values      Array of values to be written to each item.
		//						Qualities   Array of qualities to be written to each item.
		//						Timestamps  Array of timestamps to be written to each item.
		//						Errors      Array of item-level return codes. Possible values
		//									for each element include:
		//							sdaSOK -	The corresponding tag was written successfully.
		//										That tags value, quality, and timestamp 
		//										was updated.
		//							sdaSClamp -	The corresponding tag was written 
		//										successfully, but was clamped.
		//							sdaERange -	The value was out of range. It was 
		//										not written to the tag.
		//							sdaEFail -	The write operation for the corresponding 
		//										tag failed.
		//						Result		 The overall result of the operation.
		//							sdaSOK -	All tags were written successfully. Each 
		//										tags value, quality, and timestamp was 
		//										updated. All entries in the Errors array 
		//										are sdaSOK.
		//							sdaSFalse -	The operation succeeded, but one or more 
		//										elements in the Errors array contains an 
		//										error value.
		//							sdaEFail -	The operation as a whole failed.
		//
		//	Out:	None
		//
		//	Return Values:	None
		//********************************************************************************
		private void SLIKServer1_OnWriteVQT(
			object sender, 
			NDI.SLIKDA.Interop.SLIKServer.OnWriteVQTEventArgs eventArgs)
		{																																						   //UPGRADE_NOTE: Tag was upgraded to Tag_Renamed. Click for more: //ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1061"//
			try
			{
				CSimulate.WriteTags( 
					eventArgs.Count,
					eventArgs.Tags, 
					eventArgs.Values,
					eventArgs.Qualities,
					eventArgs.Timestamps,
					eventArgs.Errors, 
					ref eventArgs.Result
					);
			}
			catch( System.Exception e )
			{
				ReportEvent( e.Message , "OnWriteVQT Event Error" );
				eventArgs.Result = (int) OPCDAErrorsEnum.sdaEFail;
			}
		}


		//********************************************************************************
		// Description:	This event is fired when SLIK-DA is outputting a trace
		//				message, if and only if the trace destination was set to
		//				sdaTraceToEvent via the SetTraceInfo() method.
		//
		// Parameters:
		//   In:	sender	-	the SLIKServer object that fired the event
		//			eventArgs -	an System.EventArgs derived object that contains the
		//						following members:
		//
		//   						TraceMessage	The trace message string.
		//
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void SLIKServer1_OnTrace(
			object sender, 
			NDI.SLIKDA.Interop.SLIKServer.OnTraceEventArgs eventArgs)
		{
			// Remove the trailing newline character
			eventArgs.TraceMessage = eventArgs.TraceMessage.TrimEnd("\n".ToCharArray());
			LogTraceMessage( eventArgs.TraceMessage );
		}

		//********************************************************************************
		// Description:      Periodic event to update the server statistics view.
		//
		// Parameters:
		//   In:             None
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void tmrMain_Tick(System.Object eventSender , System.EventArgs eventArgs ) 
		{
			UpdateStatsView();
		}

		//********************************************************************************
		// Description:		Periodic event to update tags.  This demonstrates a polling
		//					methodology for tag updates.
		//
		// Parameters:
		//   In:             None
		//
		//   Out:            None
		//
		// Return Value:     None
		//********************************************************************************
		private void tmrTagUpdate_Tick( object sender, System.EventArgs eventArgs )
		{

			if( !tmrTagUpdate.Enabled ) 
				return;
			tmrTagUpdate.Enabled = false;

			try
			{
				CSimulate.UpdateTags( SLIKServer1.SLIKTags );
			}
			catch( System.Exception e )
			{
				ReportEvent( e.Message , "tmrTagUpdate_Tick Event Error" );
			}
			
			tmrTagUpdate.Enabled = true;
		}


	}
}
